%This script tests the protected properties defined by BertiniLab
function test_suite = testProtectedProperties %#ok<*STOUT>
initTestSuite;

function s = setup %#ok<*DEFNU>
mc = ?BertiniLab; % Create a metaclas
mp = mc.PropertyList; % Extract info on properties

% Now create structure with defaults for output information
pnames = struct('solve_summary','');
s.mp = mp;
s.pnames = pnames;

function testDefaults(s)
pnames = fieldnames(s.pnames);
pvals = struct2cell(s.pnames);
mp = s.mp;

% Now check default for each argument
for ii=1:length(pnames)
    for jj=1:length(mp)
        found = false;
        if strcmp(mp(jj).Name,pnames{ii})
            found = true;
            break
        end
    end
    assertTrue(found)
    assertEqual(mp(jj).SetAccess,'protected')
    assertTrue(mp(jj).HasDefault)
    assertEqual(mp(jj).DefaultValue,pvals{ii})
end